import 'dart:convert';

import 'package:viserpay_agent/data/model/auth/sign_up_model/registration_response_model.dart';

// final homeResponseModel = homeResponseModelFromJson(jsonString);

HomeResponseModel homeResponseModelFromJson(String str) => HomeResponseModel.fromJson(json.decode(str));

String homeResponseModelToJson(HomeResponseModel data) => json.encode(data.toJson());

class HomeResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  HomeResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory HomeResponseModel.fromJson(Map<String, dynamic> json) => HomeResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  Agent? agent;
  List<LatestTrx>? latestTrx;
  Last7DaycashInOut? last7DaycashInOut;
  String? totalAddMoney;
  String? totalWithdraw;

  Data({
    this.agent,
    this.latestTrx,
    this.last7DaycashInOut,
    this.totalAddMoney,
    this.totalWithdraw,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        agent: json["agent"] == null ? null : Agent.fromJson(json["agent"]),
        latestTrx: json["latest_trx"] == null ? [] : List<LatestTrx>.from(json["latest_trx"]!.map((x) => LatestTrx.fromJson(x))),
        last7DaycashInOut: json["last_7_day_money_in_out"] == null ? null : Last7DaycashInOut.fromJson(json["last_7_day_money_in_out"]),
        totalAddMoney: json["total_add_money"],
        totalWithdraw: json["total_withdraw"],
      );

  Map<String, dynamic> toJson() => {
        "agent": agent?.toJson(),
        "latest_trx": latestTrx == null ? [] : List<dynamic>.from(latestTrx!.map((x) => x.toJson())),
        "last_7_day_money_in_out": last7DaycashInOut?.toJson(),
        "total_add_money": totalAddMoney,
        "total_withdraw": totalWithdraw,
      };
}

class Agent {
  int? id;
  String? firstname;
  String? lastname;
  String? username;
  String? email;
  String? countryCode;
  String? mobile;
  String? refBy;
  String? balance;
  dynamic image;
  Address? address;
  String? status;
  String? kv;
  dynamic kycData;
  String? ev;
  String? sv;
  String? profileComplete;
  dynamic verCode;
  dynamic verCodeSendAt;
  String? ts;
  String? tv;
  dynamic tsc;
  dynamic banReason;
  dynamic rememberToken;
  DateTime? createdAt;
  DateTime? updatedAt;
  String? getImage;

  Agent({
    this.id,
    this.firstname,
    this.lastname,
    this.username,
    this.email,
    this.countryCode,
    this.mobile,
    this.refBy,
    this.balance,
    this.image,
    this.address,
    this.status,
    this.kv,
    this.kycData,
    this.ev,
    this.sv,
    this.profileComplete,
    this.verCode,
    this.verCodeSendAt,
    this.ts,
    this.tv,
    this.tsc,
    this.banReason,
    this.rememberToken,
    this.createdAt,
    this.updatedAt,
    this.getImage,
  });

  factory Agent.fromJson(Map<String, dynamic> json) => Agent(
        id: json["id"],
        firstname: json["firstname"],
        lastname: json["lastname"],
        username: json["username"],
        email: json["email"],
        countryCode: json["country_code"],
        mobile: json["mobile"],
        refBy: json["ref_by"].toString(),
        balance: json["balance"],
        image: json["image"],
        address: json["address"] == null ? null : Address.fromJson(json["address"]),
        status: json["status"].toString(),
        kv: json["kv"].toString(),
        kycData: json["kyc_data"],
        ev: json["ev"].toString(),
        sv: json["sv"].toString(),
        profileComplete: json["profile_complete"].toString(),
        verCode: json["ver_code"].toString(),
        verCodeSendAt: json["ver_code_send_at"].toString(),
        ts: json["ts"].toString(),
        tv: json["tv"].toString(),
        tsc: json["tsc"].toString(),
        banReason: json["ban_reason"].toString(),
        rememberToken: json["remember_token"].toString(),
        createdAt: json["created_at"] == null ? null : DateTime.parse(json["created_at"]),
        updatedAt: json["updated_at"] == null ? null : DateTime.parse(json["updated_at"]),
        getImage: json["get_image"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "firstname": firstname,
        "lastname": lastname,
        "username": username,
        "email": email,
        "country_code": countryCode,
        "mobile": mobile,
        "ref_by": refBy,
        "balance": balance,
        "image": image,
        "address": address?.toJson(),
        "status": status,
        "kv": kv,
        "kyc_data": kycData,
        "ev": ev,
        "sv": sv,
        "profile_complete": profileComplete,
        "ver_code": verCode,
        "ver_code_send_at": verCodeSendAt,
        "ts": ts,
        "tv": tv,
        "tsc": tsc,
        "ban_reason": banReason,
        "remember_token": rememberToken,
        "created_at": createdAt?.toIso8601String(),
        "updated_at": updatedAt?.toIso8601String(),
        "get_image": getImage,
      };
}

class Address {
  String? address;
  String? city;
  String? state;
  String? zip;
  String? country;

  Address({
    this.address,
    this.city,
    this.state,
    this.zip,
    this.country,
  });

  factory Address.fromJson(Map<String, dynamic> json) => Address(
        address: json["address"],
        city: json["city"],
        state: json["state"],
        zip: json["zip"],
        country: json["country"],
      );

  Map<String, dynamic> toJson() => {
        "address": address,
        "city": city,
        "state": state,
        "zip": zip,
        "country": country,
      };
}

class Last7DaycashInOut {
  String? totalMoneyIn;
  String? totalMoneyOut;

  Last7DaycashInOut({
    this.totalMoneyIn,
    this.totalMoneyOut,
  });

  factory Last7DaycashInOut.fromJson(Map<String, dynamic> json) => Last7DaycashInOut(
        totalMoneyIn: json["totalMoneyIn"].toString(),
        totalMoneyOut: json["totalMoneyOut"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "totalMoneyIn": totalMoneyIn,
        "totalMoneyOut": totalMoneyOut,
      };
}

class LatestTrx {
  int? id;
  String? setupDonationId;
  String? userId;
  String? userType;
  String? receiverId;
  dynamic receiverType;
  String? beforeCharge;
  String? amount;
  String? charge;
  String? postBalance;
  String? trxType;
  dynamic chargeType;
  String? trx;
  String? details;
  String? remark;
  dynamic reference;
  String? hideIdentity;
  String? createdAt;
  String? updatedAt;
  dynamic receiverUser;
  dynamic receiverAgent;
  dynamic receiverMerchant;

  LatestTrx({
    this.id,
    this.setupDonationId,
    this.userId,
    this.userType,
    this.receiverId,
    this.receiverType,
    this.beforeCharge,
    this.amount,
    this.charge,
    this.postBalance,
    this.trxType,
    this.chargeType,
    this.trx,
    this.details,
    this.remark,
    this.reference,
    this.hideIdentity,
    this.createdAt,
    this.updatedAt,
    this.receiverUser,
    this.receiverAgent,
    this.receiverMerchant,
  });

  factory LatestTrx.fromJson(Map<String, dynamic> json) => LatestTrx(
        id: json["id"],
        setupDonationId: json["setup_donation_id"].toString(),
        userId: json["user_id"].toString(),
        userType: json["user_type"].toString(),
        receiverId: json["receiver_id"].toString(),
        receiverType: json["receiver_type"].toString(),
        beforeCharge: json["before_charge"].toString(),
        amount: json["amount"].toString(),
        charge: json["charge"].toString(),
        postBalance: json["post_balance"].toString(),
        trxType: json["trx_type"],
        chargeType: json["charge_type"],
        trx: json["trx"],
        details: json["details"],
        remark: json["remark"],
        reference: json["reference"].toString(),
        hideIdentity: json["hide_identity"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
        receiverUser: json["receiver_user"].toString(),
        receiverAgent: json["receiver_agent"].toString(),
        receiverMerchant: json["receiver_merchant"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "setup_donation_id": setupDonationId,
        "user_id": userId,
        "user_type": userType,
        "receiver_id": receiverId,
        "receiver_type": receiverType,
        "before_charge": beforeCharge,
        "amount": amount,
        "charge": charge,
        "post_balance": postBalance,
        "trx_type": trxType,
        "charge_type": chargeType,
        "trx": trx,
        "details": details,
        "remark": remark,
        "reference": reference,
        "hide_identity": hideIdentity,
        "created_at": createdAt?.toString(),
        "updated_at": updatedAt?.toString(),
        "receiver_user": receiverUser,
        "receiver_agent": receiverAgent,
        "receiver_merchant": receiverMerchant,
      };
}
